/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import java.util.Objects;
import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.impl.ui.ProgressOverlayElement;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.util.FluidInput;

public class FluidStackElement
extends ProgressOverlayElement {
    private final JadeFluidObject fluid;

    public FluidStackElement(JadeFluidObject fluid) {
        this.fluid = Objects.requireNonNull(fluid);
        this.height = 16;
        this.width = 16;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.floatingRect == null) {
            DisplayHelper.INSTANCE.drawFluid(graphics, this.getX(), this.getY(), this.fluid, this.width, this.height, JadeFluidObject.bucketVolume());
        } else {
            DisplayHelper.INSTANCE.drawFluid(graphics, this.floatingRect.getX(), this.floatingRect.getY(), this.fluid, this.floatingRect.getWidth(), this.floatingRect.getHeight(), JadeFluidObject.bucketVolume());
        }
    }

    @Override
    @Nullable
    public Component getNarration() {
        return null;
    }

    @Override
    public boolean copyToClipboard(KeyboardHandler keyboardHandler) {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        if (connection == null) {
            return false;
        }
        keyboardHandler.setClipboard(new FluidInput(this.fluid).serialize((HolderLookup.Provider)connection.registryAccess()));
        return true;
    }
}

